//===================================================================================
// CocaineKilo
//===================================================================================
class CocaineKilo extends DeusExPickup;

#exec OBJ LOAD FILE=CoreTexGlass

#exec TEXTURE IMPORT NAME="CocainePowder" FILE="C:\DeusEx\MarkistanCity\Textures\CocainePowder.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="CrappyTape" FILE="C:\DeusEx\MarkistanCity\Textures\CrappyTape.pcx" GROUP=Skins

#exec TEXTURE IMPORT NAME="BeltIconCocaine" FILE="C:\DeusEx\MarkistanCity\Textures\BeltIconCocaine.pcx" GROUP=UI FLAGS=2

#exec MESH IMPORT MESH=CocaineKilo ANIVFILE=MODELS\CocaineKilo_a.3d DATAFILE=MODELS\CocaineKilo_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=CocaineKilo X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=CocaineKilo SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=CocaineKilo SEQ=CocaineKilo STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=CocaineKilo MESH=CocaineKilo
#exec MESHMAP SCALE MESHMAP=CocaineKilo X=0.0214850 Y=0.0214850 Z=0.0214850

#exec MESHMAP SETTEXTURE MESHMAP=CocaineKilo NUM=0 TEXTURE=CocainePowder
#exec MESHMAP SETTEXTURE MESHMAP=CocaineKilo NUM=1 TEXTURE=Mirror_Highligh
#exec MESHMAP SETTEXTURE MESHMAP=CocaineKilo NUM=2 TEXTURE=CrappyTape


/*var float LoneTime;

function Tick(float DT)
{
 Super.Tick(DT);
 
 if (Owner == None)
 {
  LoneTime += DT;
  
  if (LoneTime > 15)
  {
   Destroy();
  }
 }
}*/

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot >= 0);
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	Copy = Super.SpawnCopy(Other);
	Copy.bTossedOut = False;

	return Copy;
}

function DropFrom(vector StartLocation)
{

   if (Level.Netmode != NM_Standalone)
      bTossedOut = true;
	Super.DropFrom(StartLocation);
}

function BecomePickup()
{
	Super.BecomePickup();

   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 15.0;
}

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;
		
		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
		{
			player.drugEffectTimer += 120;
                        if (Player.drugEffectTimer > 200) player.TakeDamage( 15, Player, Player.Location, Normal(Player.Velocity), 'Poison');
		}

		UseOnce();
	}
Begin:
}

defaultproperties
{
     ItemArticle="a"
     ItemName="Kilo of Cocaine"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'MarkistanCity.CocaineKilo'
     PickupViewMesh=LodMesh'MarkistanCity.CocaineKilo'
     ThirdPersonMesh=LodMesh'MarkistanCity.CocaineKilo'
     Icon=Texture'MarkistanCity.UI.BeltIconCocaine'
     Description="It's a hell of a drug."
     beltDescription="COCAINE"
     Mesh=LodMesh'MarkistanCity.CocaineKilo'
     CollisionRadius=4.500000
     CollisionHeight=1.000000
     Mass=1.000000
     MaxCopies=1
     Texture=Texture'CoreTexGlass.Mirror_Highligh'
     maxCopies=15
     bCanHaveMultipleCopies=True
     bActivatable=True
}
